//
//  マジックスクロール ver1.00
//
// author yana
//

var Imported = Imported || {};
Imported['MagicScroll'] = 1.00;
/*:
 * @plugindesc ver1.00/所持しているだけでスキルが使用可能になるアイテム、スクロールを製作できるようにします。
 * @author Yana
 * 
 * @help ------------------------------------------------------
 * 使用方法
 * ------------------------------------------------------
 * アイテムのメモ欄に
 * <スクロール:x>
 * または、
 * <Scroll:x>
 * と記述すると、IDx番のスキルを使用可能になるスクロールとして機能します。
 * 
 * ------------------------------------------------------
 * 利用規約
 * ------------------------------------------------------ 
 * 使用に制限はありません。商用、アダルト、いずれにも使用できます。
 * 二次配布も制限はしませんが、サポートは行いません。
 * 著作表示は任意です。行わなくても利用できます。
 * 要するに、特に規約はありません。
 * バグ報告や使用方法等のお問合せはネ実ツクールスレ、または、Twitterにお願いします。
 * https://twitter.com/yanatsuki_
 * 素材利用は自己責任でお願いします。
 * ------------------------------------------------------
 * 更新履歴:
 * ver1.00:
 * 公開
 */

(function(){
	////////////////////////////////////////////////////////////////////////////////////
	
	var parameters = PluginManager.parameters('MagicScroll');
	
	////////////////////////////////////////////////////////////////////////////////////
	
	DataManager.isScroll = function(item) {
		if (!item){ return false }
		return !!item.meta['スクロール'] || !!item.meta['Scroll'];
	};
	
	DataManager.scrollSkills = function(item){
		if (!item){ return [] }
		if (item._scrollSkills === undefined) {
			item._scrollSkills = [];
			var texts = item.note.split('\n');
			for (var i=0,max=texts.length;i<max;i++){
				var text = texts[i];
				if (text.match(/<(?:スクロール|Scroll):(\d+)>/)){
					item._scrollSkills.push(Number(RegExp.$1));
				}
			}
		}
		return item._scrollSkills;
	};

	var _Game_System_onAfterLoad = Game_System.prototype.onAfterLoad;
	Game_System.prototype.onAfterLoad = function() {
		_Game_System_onAfterLoad.apply(this, arguments);
		$gameParty.refreshScroll();
	};

	////////////////////////////////////////////////////////////////////////////////////
	
	var __GParty_gainItem = Game_Party.prototype.gainItem;
	Game_Party.prototype.gainItem = function(item,amount,includeEquip){
		__GParty_gainItem.call(this,item,amount,includeEquip);
		if (item && DataManager.isScroll(item)){ this.refreshScroll() }
	};

	Game_Party.prototype.refreshScroll = function() {
		var scrolls = this.allItems().filter(function(item){
			return DataManager.isScroll(item);
		});
		var skills = scrolls.reduce(function(r,s){
			return r.concat(DataManager.scrollSkills(s));
		},[]);
		if (skills.length < 1) return;
		var popup = CommonPopupManager._popEnable;
		if (CommonPopupManager._popEnable) CommonPopupManager._popEnable = false;
		skills.forEach(function(skillId) {
			this.allMembers().forEach(function(actor) {
				if (!actor.isLearnedSkill(skillId)) actor.learnSkill(skillId);
			});
		}, this);
		CommonPopupManager._popEnable = popup;
	};

	var _Game_Party_addActor      = Game_Party.prototype.addActor;
	Game_Party.prototype.addActor = function(actorId) {
		var length = this._actors.length;
		_Game_Party_addActor.apply(this, arguments);
		if (length !== this._actors.length) {
			this.refreshScroll();
		}
	};

	////////////////////////////////////////////////////////////////////////////////////
	
}());
	